<?php
/**
 * Block Pattern Class
 *
 * @author Jegstudio
 * @package contrax
 */

namespace Contrax;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use WP_Block_Pattern_Categories_Registry;

/**
 * Init Class
 *
 * @package contrax
 */
class Block_Patterns {

	/**
	 * Instance variable
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Class instance.
	 *
	 * @return BlockPatterns
	 */
	public static function instance() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}

		return static::$instance;
	}

	/**
	 * Class constructor.
	 */
	public function __construct() {
		$this->register_block_patterns();
		$this->register_synced_patterns();
	}

	/**
	 * Register Block Patterns
	 */
	private function register_block_patterns() {
		$block_pattern_categories = array(
			'contrax-basic' => array( 'label' => __( 'Contrax Basic Patterns', 'contrax' ) ),
		);

		if ( defined( 'GUTENVERSE' ) ) {
			$block_pattern_categories['contrax-gutenverse'] = array( 'label' => __( 'Contrax Gutenverse Patterns', 'contrax' ) );
			$block_pattern_categories['contrax-pro'] = array( 'label' => __( 'Contrax Gutenverse PRO Patterns', 'contrax' ) );
		}

		$block_pattern_categories = apply_filters( 'contrax_block_pattern_categories', $block_pattern_categories );

		foreach ( $block_pattern_categories as $name => $properties ) {
			if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
				register_block_pattern_category( $name, $properties );
			}
		}

		$block_patterns = array(
            
		);

		if ( defined( 'GUTENVERSE' ) ) {
            
            $block_patterns[] = 'contrax-gutenverse-pro-popup';
			$block_patterns[] = 'contrax-home-gutenverse-pro-hero';
			$block_patterns[] = 'contrax-home-gutenverse-pro-about';
			$block_patterns[] = 'contrax-home-gutenverse-pro-services';
			$block_patterns[] = 'contrax-gutenverse-pro-funfact';
			$block_patterns[] = 'contrax-home-gutenverse-pro-gallery';
			$block_patterns[] = 'contrax-home-gutenverse-pro-process';
			$block_patterns[] = 'contrax-home-gutenverse-pro-testimonials';
			$block_patterns[] = 'contrax-gutenverse-pro-blog';
			$block_patterns[] = 'contrax-gutenverse-pro-popup';
			$block_patterns[] = 'contrax-about-gutenverse-pro-hero';
			$block_patterns[] = 'contrax-gutenverse-pro-funfact';
			$block_patterns[] = 'contrax-about-gutenverse-pro-mission-vision';
			$block_patterns[] = 'contrax-home-gutenverse-pro-about';
			$block_patterns[] = 'contrax-about-gutenverse-pro-team';
			$block_patterns[] = 'contrax-gutenverse-pro-popup';
			$block_patterns[] = 'contrax-services-gutenverse-pro-hero';
			$block_patterns[] = 'contrax-services-gutenverse-pro-features';
			$block_patterns[] = 'contrax-services-gutenverse-pro-services';
			$block_patterns[] = 'contrax-services-gutenverse-pro-pricing';
			$block_patterns[] = 'contrax-services-gutenverse-pro-faq';
			$block_patterns[] = 'contrax-project-gutenverse-pro-hero';
			$block_patterns[] = 'contrax-project-gutenverse-pro-gallery';
			$block_patterns[] = 'contrax-project-details-gutenverse-pro-hero';
			$block_patterns[] = 'contrax-project-details-gutenverse-pro-gallery';
			$block_patterns[] = 'contrax-project-details-gutenverse-pro-content';
			$block_patterns[] = 'contrax-project-details-gutenverse-pro-cta';
			$block_patterns[] = 'contrax-gutenverse-pro-blog';
			$block_patterns[] = 'contrax-faq-gutenverse-pro-hero';
			$block_patterns[] = 'contrax-faq-gutenverse-pro-faq';
			$block_patterns[] = 'contrax-blog-gutenverse-pro-hero';
			$block_patterns[] = 'contrax-blog-gutenverse-pro-blog';
			$block_patterns[] = 'contrax-single-blog-gutenverse-pro-hero';
			$block_patterns[] = 'contrax-contact-gutenverse-pro-hero';
			$block_patterns[] = 'contrax-contact-gutenverse-pro-contact';
			$block_patterns[] = 'contrax-contact-gutenverse-pro-maps';
			$block_patterns[] = 'contrax-404-gutenverse-pro-404';
			$block_patterns[] = 'contrax-header-gutenverse-pro';
			$block_patterns[] = 'contrax-footer-gutenverse-pro-cta';
			$block_patterns[] = 'contrax-footer-gutenverse-pro-footer';
			$block_patterns[] = 'contrax-archive-gutenverse-pro-hero';
			$block_patterns[] = 'contrax-search-gutenverse-pro-hero';
			$block_patterns[] = 'contrax-index-gutenverse-pro-hero';
		}

		$block_patterns = apply_filters( 'contrax_block_patterns', $block_patterns );
		$pattern_list   = get_option( 'contrax_synced_pattern_imported', false );
		if ( ! $pattern_list ) {
			$pattern_list = array();
		}

		if ( function_exists( 'register_block_pattern' ) ) {
			foreach ( $block_patterns as $block_pattern ) {
				$pattern_file = get_theme_file_path( '/inc/patterns/' . $block_pattern . '.php' );
				$pattern_data = require $pattern_file;

				if ( (bool) $pattern_data['is_sync'] ) {
					$post = get_page_by_path( $block_pattern . '-synced', OBJECT, 'wp_block' );
					if ( empty( $post ) ) {
						$post_id = wp_insert_post(
							array(
								'post_name'    => $block_pattern . '-synced',
								'post_title'   => $pattern_data['title'],
								'post_content' => $pattern_data['content'],
								'post_status'  => 'publish',
								'post_author'  => 1,
								'post_type'    => 'wp_block',
							)
						);

						$pattern_data['content']  = '<!-- wp:block {"ref":' . $post_id . '} /-->';
						$pattern_data['inserter'] = false;
						$pattern_data['slug']     = $block_pattern;

						$pattern_list[] = $pattern_data;
					}
				} else {
					register_block_pattern(
						'contrax/' . $block_pattern,
						require $pattern_file
					);
				}
			}
			update_option( 'contrax_synced_pattern_imported', $pattern_list );
		}
	}

	/**
	 * Register Synced Patterns
	 */
	 private function register_synced_patterns() {
		$patterns = get_option( 'contrax_synced_pattern_imported' );

		 foreach ( $patterns as $block_pattern ) {
			 register_block_pattern(
				'contrax/' . $block_pattern['slug'],
				$block_pattern
			);
		 }
	 }
}
