<?php
/**
 * Block Pattern Class
 *
 * @author Jegstudio
 * @package contrax
 */
namespace Contrax;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Init Class
 *
 * @package contrax
 */
class Asset_Enqueue {
	/**
	 * Class constructor.
	 */
	public function __construct() {
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'enqueue_block_assets', array( $this, 'enqueue_scripts' ) );
	}

    /**
	 * Enqueue scripts and styles.
	 */
	public function enqueue_scripts() {
		wp_enqueue_style( 'contrax-style', get_stylesheet_uri(), array(), CONTRAX_VERSION );

		wp_enqueue_style( 'Presset', CONTRAX_URI . '/assets/css/Presset.css', array(), CONTRAX_VERSION );


        if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
    }
}
